/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.client.column;

import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.Configuration;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ColumnDecoder;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.DataType;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ReadableByteBuf;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.message.server.ColumnDefinitionPacket;

public class SignedMediumIntColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public SignedMediumIntColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return Integer.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return 4;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return "MEDIUMINT";
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        return this.decodeIntText(buf, length);
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        return this.decodeIntBinary(buf, length);
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, int length) throws SQLDataException {
        String s = buf.readAscii(length);
        return !"0".equals(s);
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        return buf.readInt() != 0;
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, int length) throws SQLDataException {
        long result = buf.atoll(length);
        if ((long)((byte)result) != result) {
            throw new SQLDataException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        long result = buf.readMedium();
        buf.skip();
        if ((long)((byte)result) != result) {
            throw new SQLDataException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        return buf.readString(length);
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        String mediumStr = String.valueOf(this.isSigned() ? buf.readMedium() : buf.readUnsignedMedium());
        buf.skip();
        return mediumStr;
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, int length) throws SQLDataException {
        long result = buf.atoll(length);
        if ((long)((short)result) != result) {
            throw new SQLDataException("Short overflow");
        }
        return (short)result;
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        long result = buf.readMedium();
        buf.skip();
        if ((long)((short)result) != result) {
            throw new SQLDataException("Short overflow");
        }
        return (short)result;
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, int length) throws SQLDataException {
        return (int)buf.atoll(length);
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        int res = buf.readMedium();
        buf.skip();
        return res;
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, int length) throws SQLDataException {
        return buf.atoll(length);
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        long l = buf.readMedium();
        buf.skip();
        return l;
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, int length) throws SQLDataException {
        return Float.parseFloat(buf.readAscii(length));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        float f = buf.readMedium();
        buf.skip();
        return f;
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, int length) throws SQLDataException {
        return Double.parseDouble(buf.readAscii(length));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        double f = buf.readMedium();
        buf.skip();
        return f;
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }
}

